/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	VillagerBio
**
** DESCRIPTION:	Villager bio
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef VILLAGER_BIO_H
#define VILLAGER_BIO_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include <string.h>
#include "../Game/Isola.h"
#include "SkillTypes.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
#define numFemaleSets							30	//TODO:consts
#define numMaleSets								30
#define numVillagerSets							30

/******************************************************************************\
** CLASS ENUMERATIONS
\******************************************************************************/
enum EGender
{
	eGender_Unknown = -1,
	eGender_Male,
	eGender_Female
};

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CVillagerBio
{
private:

	//class data
	int			m_iAge;
	EGender		m_eGender;
	int			m_iFName;
	int			m_iLName;
	char		m_sFirstName[maxNameLength];
	int			m_iHeadType;
	int			m_iBodyType;

	char		m_sFatherName[maxNameLength];
	char		m_sMotherName[maxNameLength];
	int			m_iFatherHeadType;
	int			m_iFatherBodyType;
	int			m_iMotherHeadType;
	int			m_iMotherBodyType;
	ESkill		m_eFatherSkillType; 
	int			m_iFatherSkillValue;
	int			m_iFatherLName;

	char		m_sHusbandName[maxNameLength];
	int			m_iHusbandBodyType;
	int			m_iHusbandHeadType;	

	//class methods
	//setup
	public:		CVillagerBio();
	public:		void Copy(CVillagerBio &Bio);
	public:		void Reset();

	//process

	//access
	public:		const bool IsMale() const { return m_eGender == eGender_Male; }
	public:		const bool IsFemale() const { return m_eGender == eGender_Female; }
	public:		const bool IsAdult() const { return m_iAge >= agesUntilAdult; }
	public:		const bool IsChild() const { return m_iAge < agesUntilAdult; }
	public:		const bool IsElderly() const { return m_iAge >= agesUntilElderly; }
	public:		const bool IsNotElderly() const { return m_iAge < agesUntilElderly; }
	public:		const bool IsOld() const;
	public:		const bool IsNotOld() const;
	public:		const bool HasGreyHair() const { return m_iAge >= (agesUntilElderly + greyHairOnsetOffset); }
	public:		const bool IsFertile() const { return m_iAge >= agesUntilFertile; }
	public:		const bool IsNotFertile() const { return m_iAge < agesUntilFertile; }

	public:		void SetGender(const EGender eGender) { m_eGender = eGender; }
	public:		const EGender Gender() const { return m_eGender; }

	public:		void SetAge(const int iAge) { m_iAge = iAge; }
	public:		void IncrementAge(const int iAge);
	public:		const int Age() const { return m_iAge; }

	public:		void SetRandomName(const int iLName = -1);
	public:		void SetFirstName(const char *psName) { strncpy(m_sFirstName, psName, maxNameLength - 1); }
	public:		const char *FirstName() const { return m_sFirstName; }
	public:		const int FName() const { return m_iFName; }
	public:		const int LName() const { return m_iLName; }

	public:		void SetBodyType(const int iBodyType) { m_iBodyType = iBodyType; }
	public:		const int BodyType() const { return m_iBodyType; }
	public:		void SetHeadType(const int iHeadType) { m_iHeadType = iHeadType; if (m_iHeadType < 0) m_iHeadType = 0; else if(m_iHeadType >= numVillagerSets) m_iHeadType = numVillagerSets - 1;}
	public:		const int HeadType() const { return m_iHeadType; }

	public:		void SetMotherName(const char *psName) { strncpy(m_sMotherName, psName, maxNameLength - 1); }
	public:		const char *MotherName() const { return m_sMotherName; }
	public:		void SetFatherName(const char *psName) { strncpy(m_sFatherName, psName, maxNameLength - 1); }
	public:		const char *FatherName() const { return m_sFatherName; }

	public:		void SetFatherBodyType(const int iBodyType) { m_iFatherBodyType = iBodyType; }
	public:		const int FatherBodyType() const { return m_iFatherBodyType; }
	public:		void SetMotherBodyType(const int iBodyType) { m_iMotherBodyType = iBodyType; }
	public:		const int MotherBodyType() const { return m_iMotherBodyType; }
	public:		void SetFatherHeadType(const int iHeadType) { m_iFatherHeadType = iHeadType; }
	public:		const int FatherHeadType() const { return m_iFatherHeadType; }
	public:		void SetMotherHeadType(const int iHeadType) { m_iMotherHeadType = iHeadType; }
	public:		const int MotherHeadType() const { return m_iMotherHeadType; }

	public:		void SetFatherLName(const int iLName) { m_iFatherLName = iLName; }
	public:		void SetFatherSkillType(const ESkill eSkill) { m_eFatherSkillType = eSkill; }
	public:		const ESkill FatherSkillType() const { return m_eFatherSkillType; }
	public:		void SetFatherSkillValue(const int iValue) { m_iFatherSkillValue = iValue; }
	public:		const int FatherSkillValue() const { return m_iFatherSkillValue; }

	public:		void SetHusbandName(const char *psName) { strncpy(m_sHusbandName, psName, maxNameLength - 1); }
	public:		const char *HusbandName() const { return m_sHusbandName; }
	public:		void SetHusbandBodyType(const int iType) { m_iHusbandBodyType = iType; }
	public:		const int HusbandBodyType() const { return m_iHusbandBodyType; }
	public:		void SetHusbandHeadType(const int iType) { m_iHusbandHeadType = iType; }
	public:		const int HusbandHeadType() const { return m_iHusbandHeadType; }
};

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/